/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.impl.client.render.model;

import java.util.Iterator;
import net.createmod.catnip.client.render.model.ShadeSeparatedBufferSource;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.impl.client.render.TransformingVertexConsumer;
import net.createmod.catnip.impl.client.render.model.DefaultShadeSeparatedBufferSource;
import net.createmod.catnip.impl.client.render.model.UniversalMeshEmitter;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import org.jetbrains.annotations.Nullable;

public final class BakedModelBuffererImpl {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private BakedModelBuffererImpl() {
    }

    public static void bufferModel(class_1087 model, class_2338 pos, class_1920 level, class_2680 state, @Nullable class_4587 poseStack, ShadeSeparatedBufferSource bufferSource) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        UniversalMeshEmitter universalEmitter = objects.universalEmitter;
        long seed = state.method_26190(pos);
        class_1921 defaultLayer = class_4696.method_23679((class_2680)state);
        universalEmitter.prepare(bufferSource, defaultLayer);
        model = universalEmitter.wrapModel(model);
        poseStack.method_22903();
        class_310.method_1551().method_1541().method_3350().method_3374(level, model, state, pos, poseStack, (class_4588)universalEmitter, false, random, seed, class_4608.field_21444);
        poseStack.method_22909();
        universalEmitter.clear();
    }

    public static void bufferModel(class_1087 model, class_2338 pos, class_1920 level, class_2680 state, @Nullable class_4587 poseStack, ShadeSeparatedResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        DefaultShadeSeparatedBufferSource bufferSource = objects.defaultBufferSource;
        bufferSource.prepare(resultConsumer);
        BakedModelBuffererImpl.bufferModel(model, pos, level, state, poseStack, bufferSource);
        bufferSource.end();
    }

    public static void bufferBlocks(Iterator<class_2338> posIterator, class_1920 level, @Nullable class_4587 poseStack, boolean renderFluids, ShadeSeparatedBufferSource bufferSource) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        UniversalMeshEmitter universalEmitter = objects.universalEmitter;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;
        class_776 renderDispatcher = class_310.method_1551().method_1541();
        class_778 blockRenderer = renderDispatcher.method_3350();
        class_778.method_20544();
        while (posIterator.hasNext()) {
            class_3610 fluidState;
            class_2338 pos = posIterator.next();
            class_2680 state = level.method_8320(pos);
            if (renderFluids && !(fluidState = state.method_26227()).method_15769()) {
                class_1921 renderType = class_4696.method_23680((class_3610)fluidState);
                transformingWrapper.prepare(bufferSource.getBuffer(renderType, true), poseStack);
                poseStack.method_22903();
                poseStack.method_46416((float)(pos.method_10263() - (pos.method_10263() & 0xF)), (float)(pos.method_10264() - (pos.method_10264() & 0xF)), (float)(pos.method_10260() - (pos.method_10260() & 0xF)));
                renderDispatcher.method_3352(pos, level, (class_4588)transformingWrapper, state, fluidState);
                poseStack.method_22909();
            }
            if (state.method_26217() != class_2464.field_11458) continue;
            long seed = state.method_26190(pos);
            class_1087 model = renderDispatcher.method_3349(state);
            class_1921 defaultLayer = class_4696.method_23679((class_2680)state);
            universalEmitter.prepare(bufferSource, defaultLayer);
            model = universalEmitter.wrapModel(model);
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            blockRenderer.method_3374(level, model, state, pos, poseStack, (class_4588)universalEmitter, true, random, seed, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        transformingWrapper.clear();
        universalEmitter.clear();
    }

    public static void bufferBlocks(Iterator<class_2338> posIterator, class_1920 level, @Nullable class_4587 poseStack, boolean renderFluids, ShadeSeparatedResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        DefaultShadeSeparatedBufferSource bufferSource = objects.defaultBufferSource;
        bufferSource.prepare(resultConsumer);
        BakedModelBuffererImpl.bufferBlocks(posIterator, level, poseStack, renderFluids, bufferSource);
        bufferSource.end();
    }

    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final DefaultShadeSeparatedBufferSource defaultBufferSource = new DefaultShadeSeparatedBufferSource();
        public final UniversalMeshEmitter universalEmitter = new UniversalMeshEmitter();
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        private ThreadLocalObjects() {
        }
    }
}

